/* This file is part of SIRIUS electronic structure library.
 *
 * Copyright (c), ETH Zurich.  All rights reserved.
 *
 * Please, refer to the LICENSE file in the root directory.
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include "sirius.hpp"
#include "testing.hpp"

using namespace sirius;

int
test_gaunt_yyy()
{
    int const lmax                      = 3;
    int const lmmax                     = (lmax + 1) * (lmax + 1);
    double ref_val[lmmax][lmmax][lmmax] = {
            {{0.28209479177387814, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., -0.28209479177387814, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0.28209479177387814, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., -0.28209479177387814, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0.28209479177387814, 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., -0.28209479177387814, 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0.28209479177387814, 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., -0.28209479177387814, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0.28209479177387814, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.28209479177387814},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.28209479177387814, 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.28209479177387814, 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.28209479177387814, 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.28209479177387814, 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.28209479177387814, 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., -0.28209479177387814, 0., 0., 0., 0., 0., 0.}},
            {{0., 0.28209479177387814, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0.28209479177387814, 0., 0., 0., 0., 0., -0.126156626101008, 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0.2185096861184158, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., -0.3090193616185517, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., -0.3090193616185517, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.0825888983611587, 0., 0.},
             {0., 0., 0.2185096861184158, 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.14304816810266882, 0., 0., 0.},
             {0., -0.126156626101008, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.20230065940342062, 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.261169028265409, 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0.3198654279343846, 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0.3198654279343846, 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., -0.261169028265409, 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0.20230065940342062, 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., -0.14304816810266882, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0.0825888983611587, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.}},
            {{0., 0., 0.28209479177387814, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., -0.2185096861184158, 0., 0., 0., 0., 0., 0., 0., 0.},
             {0.28209479177387814, 0., 0., 0., 0., 0., 0.252313252202016, 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., -0.2185096861184158, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.18467439092237178, 0.},
             {0., 0., 0., -0.2185096861184158, 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.23359668032760741, 0., 0.},
             {0., 0., 0.252313252202016, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.2477666950834761, 0., 0., 0.},
             {0., -0.2185096861184158, 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.23359668032760741, 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.18467439092237178, 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0.18467439092237178, 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., -0.23359668032760741, 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0.2477666950834761, 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., -0.23359668032760741, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0.18467439092237178, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.}},
            {{0., 0., 0., 0.28209479177387814, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., -0.3090193616185517, 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0.2185096861184158, 0., 0., 0., 0., 0., 0., 0., 0.},
             {0.28209479177387814, 0., 0., 0., 0., 0., -0.126156626101008, 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.3198654279343846},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.261169028265409, 0.},
             {0., 0., 0., -0.126156626101008, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.20230065940342062, 0., 0.},
             {0., 0., 0.2185096861184158, 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.14304816810266882, 0., 0., 0.},
             {0., -0.3090193616185517, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.0825888983611587, 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0.0825888983611587, 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., -0.14304816810266882, 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0.20230065940342062, 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., -0.261169028265409, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0.3198654279343846, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.}},
            {{0., 0., 0., 0., 0.28209479177387814, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0.3090193616185517, 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.0825888983611587, 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.18467439092237178, 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., -0.3198654279343846, 0., 0., 0., 0., 0., 0.},
             {0.28209479177387814, 0., 0., 0., 0., 0., -0.18022375157286857, 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0.2207281154418226, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., -0.18022375157286857, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., -0.3198654279343846, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.13298076013381088, 0., 0.},
             {0., 0., 0.18467439092237178, 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.18806319451591874, 0., 0., 0.},
             {0., -0.0825888983611587, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.20601290774570113, 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.18806319451591874, 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0.13298076013381088, 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.}},
            {{0., 0., 0., 0., 0., 0.28209479177387814, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0.2185096861184158, 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.14304816810266882, 0., 0., 0.},
             {0., 0.2185096861184158, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.23359668032760741, 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.261169028265409, 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., -0.2207281154418226, 0., 0., 0., 0., 0., 0., 0., 0.},
             {0.28209479177387814, 0., 0., 0., 0., 0., 0.09011187578643429, 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0.09011187578643429, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., -0.2207281154418226, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.21026104350168, 0.},
             {0., 0., 0., -0.261169028265409, 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.16286750396763996, 0., 0.},
             {0., 0., 0.23359668032760741, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.05947080387175903, 0., 0., 0.},
             {0., -0.14304816810266882, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.05947080387175903, 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.16286750396763996, 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0.21026104350168, 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.}},
            {{0., 0., 0., 0., 0., 0., 0.28209479177387814, 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0.126156626101008, 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.20230065940342062, 0., 0.},
             {0., 0., 0.252313252202016, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.2477666950834761, 0., 0., 0.},
             {0., 0.126156626101008, 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.20230065940342062, 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., -0.18022375157286857, 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., -0.09011187578643429, 0., 0., 0., 0., 0., 0., 0., 0.},
             {0.28209479177387814, 0., 0., 0., 0., 0., 0.18022375157286857, 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., -0.09011187578643429, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., -0.18022375157286857, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.21026104350168},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., -0.20230065940342062, 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.126156626101008, 0., 0.},
             {0., 0., 0.2477666950834761, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.168208834801344, 0., 0., 0.},
             {0., -0.20230065940342062, 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.126156626101008, 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0.21026104350168, 0., 0., 0., 0., 0., 0.}},
            {{0., 0., 0., 0., 0., 0., 0., 0.28209479177387814, 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.261169028265409, 0.},
             {0., 0., 0., 0.2185096861184158, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.23359668032760741, 0., 0.},
             {0., 0., 0.2185096861184158, 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.14304816810266882, 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., -0.2207281154418226, 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0.09011187578643429, 0., 0., 0., 0., 0., 0., 0., 0.},
             {0.28209479177387814, 0., 0., 0., 0., 0., 0.09011187578643429, 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., -0.2207281154418226, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.21026104350168},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.16286750396763996, 0.},
             {0., 0., 0., -0.14304816810266882, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.05947080387175903, 0., 0.},
             {0., 0., 0.23359668032760741, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.05947080387175903, 0., 0., 0.},
             {0., -0.261169028265409, 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.16286750396763996, 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.21026104350168, 0., 0., 0., 0., 0.}},
            {{0., 0., 0., 0., 0., 0., 0., 0., 0.28209479177387814, 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.3198654279343846},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.18467439092237178, 0.},
             {0., 0., 0., 0.3090193616185517, 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.0825888983611587, 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., -0.18022375157286857, 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0.2207281154418226, 0., 0., 0., 0., 0., 0., 0., 0.},
             {0.28209479177387814, 0., 0., 0., 0., 0., -0.18022375157286857, 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.13298076013381088},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.18806319451591874, 0.},
             {0., 0., 0., -0.0825888983611587, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.20601290774570113, 0., 0.},
             {0., 0., 0.18467439092237178, 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.18806319451591874, 0., 0., 0.},
             {0., -0.3198654279343846, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.13298076013381088, 0., 0., 0., 0.}},
            {{0., 0., 0., 0., 0., 0., 0., 0., 0., 0.28209479177387814, 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0.3198654279343846, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0.3198654279343846, 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.13298076013381088, 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.21026104350168, 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., -0.21026104350168, 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0.28209479177387814, 0., 0., 0., 0., 0., -0.21026104350168, 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0.21026104350168, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., -0.13298076013381088, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.}},
            {{0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.28209479177387814, 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0.261169028265409, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0.18467439092237178, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0.18467439092237178, 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.18806319451591874, 0., 0., 0.},
             {0., 0.261169028265409, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.16286750396763996, 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., -0.21026104350168, 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., -0.21026104350168, 0., 0., 0., 0., 0., 0., 0., 0.},
             {0.28209479177387814, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0.16286750396763996, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., -0.18806319451591874, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.}},
            {{0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.28209479177387814, 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0.20230065940342062, 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0.23359668032760741, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0.0825888983611587, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0.0825888983611587, 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.20601290774570113, 0., 0.},
             {0., 0., 0.23359668032760741, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.05947080387175903, 0., 0., 0.},
             {0., 0.20230065940342062, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.126156626101008, 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.16286750396763996, 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., -0.13298076013381088, 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., -0.13298076013381088, 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., -0.16286750396763996, 0., 0., 0., 0., 0., 0., 0., 0.},
             {0.28209479177387814, 0., 0., 0., 0., 0., 0.126156626101008, 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0.05947080387175903, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., -0.20601290774570113, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.}},
            {{0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.28209479177387814, 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0.14304816810266882, 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0.2477666950834761, 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0.14304816810266882, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.18806319451591874, 0.},
             {0., 0., 0., 0.14304816810266882, 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.05947080387175903, 0., 0.},
             {0., 0., 0.2477666950834761, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.168208834801344, 0., 0., 0.},
             {0., 0.14304816810266882, 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.05947080387175903, 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.18806319451591874, 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., -0.18806319451591874, 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., -0.05947080387175903, 0., 0., 0., 0., 0., 0., 0., 0.},
             {0.28209479177387814, 0., 0., 0., 0., 0., 0.168208834801344, 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., -0.05947080387175903, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., -0.18806319451591874, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.}},
            {{0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.28209479177387814, 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0.0825888983611587, 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0.23359668032760741, 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0.20230065940342062, 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.13298076013381088},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.16286750396763996, 0.},
             {0., 0., 0., 0.20230065940342062, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.126156626101008, 0., 0.},
             {0., 0., 0.23359668032760741, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.05947080387175903, 0., 0., 0.},
             {0., 0.0825888983611587, 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.20601290774570113, 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., -0.20601290774570113, 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0.05947080387175903, 0., 0., 0., 0., 0., 0., 0., 0.},
             {0.28209479177387814, 0., 0., 0., 0., 0., 0.126156626101008, 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., -0.16286750396763996, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., -0.13298076013381088, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.}},
            {{0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.28209479177387814, 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0.18467439092237178, 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0.261169028265409, 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.21026104350168},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0.261169028265409, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.16286750396763996, 0., 0.},
             {0., 0., 0.18467439092237178, 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.18806319451591874, 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., -0.18806319451591874, 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0.16286750396763996, 0., 0., 0., 0., 0., 0., 0., 0.},
             {0.28209479177387814, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., -0.21026104350168, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.}},
            {{0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.28209479177387814},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0.3198654279343846, 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.21026104350168},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.21026104350168, 0.},
             {0., 0., 0., 0.3198654279343846, 0., 0., 0., 0., 0., 0., 0., 0., 0., -0.13298076013381088, 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0., -0.13298076013381088, 0., 0., 0., 0., 0., 0., 0.},
             {0., 0., 0., 0., 0., 0., 0., 0.21026104350168, 0., 0., 0., 0., 0., 0., 0., 0.},
             {0.28209479177387814, 0., 0., 0., 0., 0., -0.21026104350168, 0., 0., 0., 0., 0., 0., 0., 0., 0.}}};

    double d{0};

    for (int l1 = 0; l1 <= lmax; l1++) {
        for (int m1 = -l1; m1 <= l1; m1++) {
            for (int l2 = 0; l2 <= lmax; l2++) {
                for (int m2 = -l2; m2 <= l2; m2++) {
                    for (int l3 = 0; l3 <= lmax; l3++) {
                        for (int m3 = -l3; m3 <= l3; m3++) {
                            d += std::abs(ref_val[sf::lm(l1, m1)][sf::lm(l2, m2)][sf::lm(l3, m3)] -
                                          SHT::gaunt_yyy(l1, l2, l3, m1, m2, m3));
                        }
                    }
                }
            }
        }
    }
    if (d < 1e-13) {
        return 0;
    } else {
        return 1;
    }
}

int
main(int argn, char** argv)
{
    return call_test(argv[0], test_gaunt_yyy);
}
