//    MCL: MiMiC Communication Library
//    Copyright (C) 2015-2025  The MiMiC Authors (see CONTRIBUTORS file for details).
//
//    This file is part of MCL.
//
//    MCL is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as
//    published by the Free Software Foundation, either version 3 of
//    the License, or (at your option) any later version.
//
//    MCL is distributed in the hope that it will be useful, but
//    WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.

#include "initialize_wrapper.h"

#include "mpi.h"

#include "mcl.h"

int MCL_InitializeWrapper(int *fortran_comm) {
    MPI_Comm c_comm = MPI_Comm_f2c(*fortran_comm);
    MCL_Initialize(&c_comm);
    *fortran_comm = MPI_Comm_c2f(c_comm);
    return 0;
}
