//    MCL: MiMiC Communication Library
//    Copyright (C) 2015-2025  The MiMiC Authors (see CONTRIBUTORS file for details).
//
//    This file is part of MCL.
//
//    MCL is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as
//    published by the Free Software Foundation, either version 3 of
//    the License, or (at your option) any later version.
//
//    MCL is distributed in the hope that it will be useful, but
//    WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.

#ifndef MCL_ERRORPRINTING_H_
#define MCL_ERRORPRINTING_H_

#include <string>

namespace mcl {

/// Prints a warning.
///   \param[in]  message  Message to print.
void PrintWarning(const std::string &message);

/// Prints an error.
///   \param[in]  message     Message to print.
///   \param[in]  file        File in which the procedure is called.
///   \param[in]  line        Line on which the procedure is called.
///   \param[in]  error_code  Optional MPI error code.
void PrintErrorMessage(const std::string &message, const char *file, int line, int error_code = 0);

/// Adds quotation marks around a string and returns as a string.
///   \param[in]  message  Message to add quotation marks to.
std::string AddQuotes(const std::string &message);

/// Adds quotation marks around a C-string and returns as a string.
///   \param[in]  message  Message to add quotation marks to.
std::string AddQuotes(const char *message);

} // namespace mcl

#endif // MCL_ERRORPRINTING_H_
