//    MCL: MiMiC Communication Library
//    Copyright (C) 2015-2025  The MiMiC Authors (see CONTRIBUTORS file for details).
//
//    This file is part of MCL.
//
//    MCL is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as
//    published by the Free Software Foundation, either version 3 of
//    the License, or (at your option) any later version.
//
//    MCL is distributed in the hope that it will be useful, but
//    WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.

#include "mcl.h"

#include "config.h"
#include "data_types.h"
#include "main_class.h"

using namespace mcl;

int MCL_Initialize(void *args) {
    return MclMain::GetInstance().Initialize(args);
}

int MCL_Finalize() {
    return MclMain::GetInstance().Finalize();
}

int MCL_Abort(int error_code) {
    return MclMain::GetInstance().Abort(error_code);
}

void MCL_GetAPIVersion(int version[3]) {
    version[0] = PROJECT_VER_MAJOR; 
    version[1] = PROJECT_VER_MINOR; 
    version[2] = PROJECT_VER_PATCH; 
}

int MCL_GetNumPrograms() {
    return MclMain::GetInstance().num_programs();
}

int MCL_GetProgramID() {
    return MclMain::GetInstance().program_id();
}

bool MCL_IsInitialized() {
    return MclMain::GetInstance().is_initialized();
}

int MCL_Send(void *data, int length, int data_type, int tag, int destination) {
    return MclMain::GetInstance().Send(data, length, data_type, tag, destination);
}
int MCL_Send(char *data, int length, int tag, int destination) {
    return MCL_Send(data, length, kTypeChar, tag, destination);
}
int MCL_Send(int *data, int length, int tag, int destination) {
    return MCL_Send(data, length, kTypeInt, tag, destination);
}
int MCL_Send(long int *data, int length, int tag, int destination) {
    return MCL_Send(data, length, kTypeLongInt, tag, destination);
}
int MCL_Send(float *data, int length, int tag, int destination) {
    return MCL_Send(data, length, kTypeFloat, tag, destination);
}
int MCL_Send(double *data, int length, int tag, int destination) {
    return MCL_Send(data, length, kTypeDouble, tag, destination);
}

int MCL_Receive(void *data, int length, int data_type, int tag, int source) {
    return MclMain::GetInstance().Receive(data, length, data_type, tag, source);
}
int MCL_Receive(char *data, int length, int tag, int source) {
    return MCL_Receive(data, length, kTypeChar, tag, source);
}
int MCL_Receive(int *data, int length, int tag, int source) {
    return MCL_Receive(data, length, kTypeInt, tag, source);
}
int MCL_Receive(long int *data, int length, int tag, int source) {
    return MCL_Receive(data, length, kTypeLongInt, tag, source);
}
int MCL_Receive(float *data, int length, int tag, int source) {
    return MCL_Receive(data, length, kTypeFloat, tag, source);
}
int MCL_Receive(double *data, int length, int tag, int source) {
    return MCL_Receive(data, length, kTypeDouble, tag, source);
}

constexpr int MCL_CHAR = kTypeChar;
constexpr int MCL_INT = kTypeInt;
constexpr int MCL_LONG_INT = kTypeLongInt;
constexpr int MCL_FLOAT = kTypeFloat;
constexpr int MCL_DOUBLE = kTypeDouble;
