//    MCL: MiMiC Communication Library
//    Copyright (C) 2015-2025  The MiMiC Authors (see CONTRIBUTORS file for details).
//
//    This file is part of MCL.
//
//    MCL is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as
//    published by the Free Software Foundation, either version 3 of
//    the License, or (at your option) any later version.
//
//    MCL is distributed in the hope that it will be useful, but
//    WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.

#ifndef MCL_TRANSPORT_STUBTRANSPORT_H_
#define MCL_TRANSPORT_STUBTRANSPORT_H_

#include "transport.h"
#include "transfer_logger.h"

namespace mcl {

/// Transport layer for faking the data transfer in external program interface tests.
/// The data is read from a file recorded during a standard run.
class StubTransport : public Transport {

  public:
    explicit StubTransport() : Transport() { }
    ~StubTransport() override = default;

    int Initialize(void *args) override;
    int Finalize() override;
    int Abort(int error_code) override;
    int Send(void *data, int length, int data_type, int tag, int destination) override;
    int Receive(void *data, int length, int data_type, int tag, int source) override;
    int ProbeSize(int data_type, int source) override;

  private:
    TransferLogger *transfer_log_;   ///< Log file from which the data is read.
    bool skipped_send_;              ///< Send transfers were not recorded.

};

} // namespace mcl

#endif // MCL_TRANSPORT_STUBTRANSPORT_H_
