@page CHANGES-2-10 Version 2.10

## Version 2.10 (Aug 25, 2025)
 
Version 2.10 is a major upgrade of PLUMED, with a lot of new features and an extensive rewrite of the core of the code.
Starting with version 2.10, we will stop supporting older compilers. For this reason, we will likely extend the support of version 2.9 longer than usual.
Before switching to version 2.10, users are invited to carefully read the following text.

- Changes relevant for users:
  - **PLUMED 2.10 requires a C++17 compatible compiler**.
  - The passing of data between actions has been made more flexible. Now, in addition to passing scalars between actions, you can also
    pass vectors, matrices and functions computed on grids between actions. The ways in which you can use these new functionalities are
    detailed at [this link](https://www.plumed-tutorials.org/lessons/23/001/data/NAVIGATION.html).
    The old input syntax for most actions should work the same as it did in previous versions of the code. However if you investigate the log
    you will see that these old functionalities are reproduced by using shortcut actions that generate more complicated plumed inputs.
  - A number of functionalities in the code have been carefully optimized. An incomplete list includes
    grids (with an impact on \ref METAD, \ref sum_hills, and other grid-based methods)
    and overhead associated to the simulation of small systems, where the overall performance should be significantly better than in previous versions.
  - The additional flexibility comes at the price of some decrease in performance.
    In most cases this decrease in performance should be negligible or largely mitigated by the other optimizations that we implemented. **We are very interested in feedback on PLUMED performances in real applications**. If you have a real application where you can see a measurable slowdown when upgrading from version 2.9 to version 2.10, please open an issue on GitHub and report it. Ideally, you could provide a simple input file for the \ref benchmark which highlights the
    performance regression.
  - It is now possible to use an embedded Python interpreter to implement collective variables and functions in Python. This is largely based on a previous implementation by Toni Giorgino
    that is described in [this paper](https://joss.theoj.org/papers/10.21105/joss.01773) and has been integrated in PLUMED by Daniele Rapetti. This feature is provided as a separate plugin
    that can be linked against the proper Python interpreter and loaded at runtime with \ref LOAD. Documentation about how to install and use this feature can be found in directory
    `plugins/pycv`.
  - A prototype of the \ref COORDINATION collective variable with limited functionalities is now included in a CUDA implementation which is orders of magnitude faster
    when using large groups. This implementation has been contributed by Daniele Rapetti and is provided as a separate plugin
    that can be linked against the proper CUDA libraries and loaded at runtime with \ref LOAD. Documentation about how to install and use this feature can be found in directory
    `plugins/cudaCoord`.
  - New CLTool \ref plotswitch for tabulating any switching function and its derivative.
  - A new `@ndx` selector can be used to read GROMACS index files (see \ref atomSpecs) without the need to explicitly declare a \ref GROUP.
  - The \ref LOAD action has been improved (see [this pull request](https://github.com/plumed/plumed2/pull/1056)).
    - It can be used in any position in the input file.
    - It is now working properly when multiple Plumed objects are present (e.g., in multithread applications or when creating multiple `Plumed()` objects in Python).

- New patches for MD codes:
  - A patch for GROMACS 2025 has been added, which is based on the native GROMACS interface to PLUMED and adds support for multiple walkers.

- Changes leading to differences with previous versions:
  - \ref GHOST now automatically makes molecules whole.  In case you do not want it to do it, use the NOPBC flag.
  - In \ref ANGLES you can no longer use the GROUP, GROUPA/GROUPB/GROUPC keywords.  Explicitly list all the distances you want to compute using ATOMS1,ATOMS2,ATOMS3...
  - Action NBONDS no longer exists.  The same effect can be achieved through a more transparent implementation that you can read about here: https://www.plumed-tutorials.org/lessons/23/001/data/Steinhardt.html
  - Action CENTER_OF_MULTICOLVAR no longer exists.  You now simply use \ref CENTER with the PHASES option and a vector as input for the weights.
  - Dimensionality reduction methods and landmark selection actions have a new syntax. A good introduction that explains how to use these actions can be found in [this tutorial](https://www.plumed-tutorials.org/lessons/21/006/data/DIMENSIONALITY.html)
  - if you use \ref DISTANCES with the GROUP or GROUPA/GROUPB syntax each distance is no longer allocated to a position in space.  You thus cannot use the GROUP or GROUPA/GROUPB variants of action with methods such as \ref DUMPMULTICOLVAR, \ref MULTICOLVARDENS or \ref SMAC.  To be clear if you use \DISTANCES with the ATOMS1/ATOMS2/ATOMS3/... syntax you can still use it with \ref DUMPMULTICOLVAR, \ref MULTICOLVARDENS or \ref SMAC.  We believe this second use case was the variant of the old version that was widely used.

- Places where we strongly recommend using the new syntax:
  - If you are using \ref DFSCLUSTERING and the \ref CLUSTER_PROPERTIES or \ref CLUSTER_DISTRIBUTION actions you are strongly encouraged to read: https://www.plumed-tutorials.org/lessons/23/001/data/Clusters.html
    We think you will find the newer syntax for these actions much easier to use.

- Modules that were built from code taken from the old crystllization and multicolvar modules.
  - symfunc contains code for computing symmetry functions much of which was taken from the old crystallization module
  - volumes contains code for determing whether atoms are within a particular part of the box or not. This is largely built from code that was formerly in the multicolvar module
  - clusters contains code for determining if atoms are clustered together or not.  This is build from code that was formerly in the crystallization module
  - gridtools contains code for doing kernel density estimation and manipulating functions on grids
  - contour contains code for computing Willard-Chandler dividing surfaces.
  - refdist contains code for calculating distances between configuations.
  - fourier contains code for computing fourier transforms of functions on grids

- New contributed modules:
  - A new crystdistrib module by Jake McKibben, Gareth Tribello and Erik Santiso for computing order parameters that can be used to study the formation of molecular crystals.
  - A new metatomic module by Guillaume Fraux and Gareth Tribello integrating with
  https://docs.metatensor.org/metatomic/ to enable the use of arbitrary machine learning
  models as collective variables.

- Changes relevant for developers:
  - Removed some shortcuts for `ActionRegister.h` (from the modules bias colvar function sasa and vatom) and `CLToolRegister.h` (from the module cltools), now the two headers can only be included with `#include "core/ActionRegister.h"` or `#include "core/CLToolRegister.h"`.
  - `plumed mklib` can now process more than one cpp file. Files are combined in a single library.
  - When loading PLUMED at runtime using PLUMED_KERNEL, plumed is loaded with `RTLD_LOCAL` by default. This facilitates running multiple PLUMED versions, e.g. for \ref benchmark.
  - On Linux, `plumed-runtime` executable can now find a working libplumedKernel.so by looking in the `dlopen` path (including `LD_LIBRARY_PATH` and stored RPATH).
    On MacOS, `plumed-runtime` executable can now find a working libplumedKernel.dylib by using a relative rpath.
    These changes should make this executable as functional as the normal `plumed` executable but with the advantage of loading symbols in a local namespace (see above).
  - A new \ref benchmark tool has been added to time execution of sample input files and facilitate the comparison across multiple PLUMED versions.
  - You can now pass any scalars, vectors, matrices and functions (and forces on these objects) in and out of PLUMED using the functionality described here: https://www.plumed-tutorials.org/lessons/23/001/data/MDInterfaceI.html
  - You can also pass vectors that are scattered across the domains by using the functionality detailed here: https://www.plumed-tutorials.org/lessons/23/001/data/MDInterfaceII.html
  - You can use ActionShortcut to create complex inputs from a simpler initial input.  The nest will then allow users to explore these more complex inputs.
  - You can use \ref show_graph to create diagrams showing how values and forces are passed between the various actions in your input files.
  - Complete refactor of SwitchingFunction.cpp and SwitchingFunction.h, now adding new switching function is more straightforward and all the "book-keeping" can be done within a single class
  - Python (cython) wrappers now use `nogil`. This should facilitate integration with Python. See https://github.com/plumed/plumed2/pull/1129#issuecomment-2410867829 (thanks to Guillaume Fraux).
